{========================================================================}
{=                (c) 1995-99 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 22.03.99 - 15:51:57 $                                        =}
{========================================================================}
unit CDMain;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  ExtCtrls,
  StdCtrls,
  Menus,
  ComCtrls,
  Buttons,
  MMSystem,
  MMObj,
  MMDSPObj,
  MMAbout,
  MMUtils,
  MMDesign,
  MMWave,
  MMWaveIO,
  MMTrigg,
  MMCDRead,
  MMCDATyp,
  MMWavIn,
  MMConect,
  MMDIBCv,
  MMLevel,
  MMACMCvt,
  MMACMDlg,
  MMHook,
  MMString, MMAudio;

type
  TTrackListBox = class(TListBox)
  private
     procedure CNDrawItem(var Message: TWMDrawItem); message CN_DRAWITEM;
  end;

  TCDMainForm = class(TForm)
    Bevel1: TBevel;
    ToolBar: TPanel;
    DevCombo: TComboBox;
    MainMenu: TMainMenu;
    DAC1: TMenuItem;
    ConfigDrive: TMenuItem;
    N2: TMenuItem;
    miExit: TMenuItem;
    Aktionen1: TMenuItem;
    N1: TMenuItem;
    Info: TMenuItem;
    SaveDlg: TSaveDialog;
    CopyBtn: TSpeedButton;
    WaveFile: TMMWaveFile;
    Panel1: TPanel;
    Header: THeader;
    Label2: TLabel;
    StatusBar: TStatusBar;
    Timer1: TTimer;
    View1: TMenuItem;
    ToolBar1: TMenuItem;
    Statusbar1: TMenuItem;
    CopyTracks1: TMenuItem;
    N5: TMenuItem;
    SelectAll1: TMenuItem;
    InvertSelection1: TMenuItem;
    MMDesigner1: TMMDesigner;
    btnPlay: TSpeedButton;
    btnPrev: TSpeedButton;
    btnNext: TSpeedButton;
    btnStop: TSpeedButton;
    btnEject: TSpeedButton;
    ACMConverter: TMMACMConverter;
    N3: TMenuItem;
    SelectWaveformat1: TMenuItem;
    ACM: TMMACM;
    Trigger: TMMTrigger;
    CDReader: TMMCDReader;
    N4: TMenuItem;
    ReadISRCCode1: TMenuItem;
    Label1: TLabel;
    SpeedCombo: TComboBox;
    Timer2: TTimer;
    editTitle: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure DevComboChange(Sender: TObject);
    procedure ResetTrackInfos;
    procedure DisplayTOC(Refresh: Boolean);
    procedure CopyClick(Sender: TObject);
    procedure TriggerStop(Sender: TObject);
    procedure WaveFileClose(Sender: TObject);
    procedure ListBoxDrawItem(Control: TWinControl; Index: Integer;
                              R: TRect; State: TOwnerDrawState);
    procedure HeaderSized(Sender: TObject; ASection, AWidth: Integer);
    procedure TriggerStart(Sender: TObject);
    procedure InfoClick(Sender: TObject);
    procedure PlayClick(Sender: TObject);
    procedure PrevClick(Sender: TObject);
    procedure NextClick(Sender: TObject);
    procedure StopClick(Sender: TObject);
    procedure EjectClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ToolBar1Click(Sender: TObject);
    procedure Statusbar1Click(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure InvertSelection1Click(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure ConfigDriveClick(Sender: TObject);
    procedure TriggerError(Sender: TObject);
    procedure TriggerClose(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure miExitClick(Sender: TObject);
    procedure SelectWaveformat1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ReadISRCCode1Click(Sender: TObject);
    procedure SpeedComboChange(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
  public
    ListBox     : TTrackListBox;
    AudioBitmap : TBitmap;
    DataBitmap  : TBitmap;
    CurDiskID   : integer;
    UseCDText   : Boolean;
    HasCDText   : Boolean;
    ISRCCodes   : array[0..99] of string;
  end;

var
  CDMainForm: TCDMainForm;

{$R IMAGES.D32}

implementation

uses CDCopy, CDConfig, CDISRC;

{$R *.DFM}

{-----------------------------------------------------------------------------}
function MSFToTimeStr(Value: Longint; MSec: Boolean): string;
var
  H, M,
  S, S100 : Integer;

begin
   Value := MSFToFrame(Value);
   S:= Value div 75;
   S100:= Value mod 75;
   H:= S div 3600;
   S:= S mod 3600;
   M:= S div 60;
   S:= S mod 60;

   Result:= Format('%d:', [H]);
   if (M < 10) then
       Result:= Result + '0' + IntToStr(M) + ':'
   else
       Result:= Result + IntToStr(M) + ':';
   if (S < 10) then
       Result:= Result + '0' + IntToStr(S)
   else
       Result:= Result + IntToStr(S);

   if MSec then
   begin
      if (S100 < 10) then
          Result:= Result + '.0' + IntToStr(S100)
      else
          Result:= Result + '.'+IntToStr(S100);
   end;
end;

{-- TTrackListbox -------------------------------------------------------------}
procedure TTrackListBox.CNDrawItem(var Message: TWMDrawItem);
begin
   with Message.DrawItemStruct^ do
   begin
      if (Items.Count > 0) then inc(rcItem.Left,CDMainForm.AudioBitmap.Width);
      inherited;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.FormCreate(Sender: TObject);
var
   wfx: array[0..1024] of Char;
   i,ID: Integer;
begin
   { create a listbox on the fly... }
   ListBox := TTrackListBox.Create(Panel1);
   with ListBox do
   begin
      Parent      := Panel1;
      Align       := alClient;
      BorderStyle := bsNone;
      ItemHeight  := 16;
      MultiSelect := True;
      Style       := lbOwnerDrawFixed;
      OnClick     := ListBoxClick;
      OnDrawItem  := ListBoxDrawItem;
      Font.Color  := clNavy;
   end;
   AudioBitmap := TBitmap.Create;
   AudioBitmap.Handle := LoadBitmap(hInstance,'BM_AUDIO');
   DataBitmap := TBitmap.Create;
   DataBitmap.Handle := LoadBitmap(hInstance,'BM_DATA');

   with CDReader do
   begin
      { restore the configuration from to the registry }
      if GetFromRegistryBinary(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','WaveFormat',wfx,sizeOf(wfx)) > 0 then
         ACMConverter.PWaveFormat := @wfx;

      ID := GetFromRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','DeviceID',DeviceID);
      BlockCount   := GetFromRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','BlockCount',BlockCount);
      CopyMode     := GetFromRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','CopyMode',CopyMode);
      IgnoreSpeed  := GetFromRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','IgnoreSpeed',IgnoreSpeed);
      UseCDText    := GetFromRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','UseCDText',UseCDText);
      
      { go trough device list }
      if (Devices.Count > 0) then
      begin
         for i := 0 to Devices.Count-1 do
         begin
            { restore the DeviceTyes from the registry }
            Devices[i].DeviceType := GetFromRegistry(HKEY_CURRENT_USER,
                                                     'Software\SwiftSoft\DAC',
                                                     'DeviceType'+IntToStr(i),
                                                     Devices[i].DeviceType);

            DevCombo.Items.Add('<'+Devices[i].DriveLetter+':>  '+
                               Devices[i].DeviceName);
         end;
         ID := MinMax(ID,0,Devices.Count-1);
         if (ID >= 0) then
             DeviceType := Devices[ID].DeviceType;
         DevCombo.ItemIndex:= ID;
         Timer1.Enabled := True;
         Timer2.Enabled := True;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.Timer2Timer(Sender: TObject);
begin
   DevComboChange(Self);
   Timer2.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
   i: integer;
begin
   Timer1.Enabled := False;
   CDReader.CloseDevice;

   { save the configuration to the registry }
   SaveInRegistryBinary(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','WaveFormat',ACMConverter.PWaveFormat^,wioSizeOfWaveFormat(ACMConverter.PWaveFormat));
   SaveInRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','BlockCount',CDReader.BlockCount);
   SaveInRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','CopyMode',CDReader.CopyMode);
   SaveInRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','DeviceID',CDReader.DeviceID);
   SaveInRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','IgnoreSpeed',CDReader.IgnoreSpeed);
   SaveInRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','UseCDText',UseCDText);

   for i := 0 to CDReader.Devices.Count-1 do
   begin
      SaveInRegistry(HKEY_CURRENT_USER,'Software\SwiftSoft\DAC','DeviceType'+IntToStr(i),
                     CDReader.Devices[i].DeviceType);
   end;

   AudioBitmap.Free;
   DataBitmap.Free;

   Action := caFree;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.DevComboChange(Sender: TObject);
var
   i: integer;
begin
  CDReader.CloseDevice;
  try
     for i := 0 to high(ISRCCodes) do ISRCCodes[i] := '';

     CDReader.DeviceID   := DevCombo.ItemIndex;
     CDReader.OpenDevice;

  except
     // no exception please !
  end;
  ResetTrackInfos;
  DisplayTOC(True);
  Update;

  SpeedCombo.Items.Clear;
  SpeedCombo.Items.Add('Detecting...');
  SpeedCombo.ItemIndex := 0;

  CDReader.DetectSupportedSpeeds;
  SpeedCombo.Items.Assign(CDReader.Speeds);

  if (SpeedCombo.Items.Count > 0) then
      SpeedCombo.ItemIndex := 0;

  ReadISRCCode1.Enabled := CDReader.CanReadISRC;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.SpeedComboChange(Sender: TObject);
begin
   if (SpeedCombo.ItemIndex >= 0) then
       CDReader.SetCopySpeed(Word(SpeedCombo.Items.Objects[SpeedCombo.ItemIndex]));
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.FormDestroy(Sender: TObject);
begin
   CDMainForm := nil;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.ReadISRCCode1Click(Sender: TObject);
var
   i: integer;
begin
   with TCDISRCDlg.Create(Self) do
   try
      Gauge.Progress := 0;
      Label1.Caption := 'Reading Track 1';
      BringtoFront;
      Show;
      Update;

      i := 0;
      while not Cancel and (i < CDReader.Tracks.Count) do
      begin
         ISRCCodes[i]   := CDReader.ReadISRC(i+1);
         inc(i);
         Gauge.Progress := (i*100)div CDReader.Tracks.Count;
         Label1.Caption := 'Reading Track '+IntToStr(i+1);
         Application.ProcessMessages;
     end;

   finally
      Free;
   end;
   DisplayTOC(False);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.DisplayTOC(Refresh: Boolean);
var
  i: integer;
  Size      : Single;
  S, CP, PE, Title, ISRC : string;

begin
  ListBox.Clear;
  with CDReader do
  if DeviceReady then
  begin
     if Refresh then
     begin
        if not ReadTOC then
           raise Exception.Create('Unable to read CD directory');

        CurDiskID := DiskID;

        HasCDText := UseCDText and ReadCDText;
     end;

     S := '';
     if HasCDText then
        S := CDText[0].Tracks[0].TrackTitle;

     editTitle.Text := S;

     for i := 0 to Tracks.Count-1 do
     with Tracks[i] do
     begin
        Size := (MSFToFrame(Length)*FRAME_SIZE) / 1024 / 1024;
        if Copyprotected then CP := 'Yes'
        else CP := 'No';
        if PreEmphasis then PE := 'Yes'
        else PE := 'No';

        Title := '';

        if (Title = '') and HasCDText then
           Title := CDText[0].Tracks[i+1].TrackTitle;

        ISRC := '';
        if HasCDText then
           ISRC := CDText[0].Tracks[i+1].UPC_EAN_ISRC;
        if (ISRC = '') then
            ISRC := ISRCCodes[i];

        if (ISRC = '') then
            ISRC := '---';

        S:= Format('%.2d'#9'%s'#9'%s'#9'%s'#9'%.2f MB'#9'%s'#9'%s'#9'%s',
                   [Number,
                    Title,
                    MSFToTimeStr(Start,True),
                    MSFToTimeStr(Length,True), Size, CP, PE,ISRC]);

        ListBox.Items.Add(S);
     end;
     if (ListBox.Items.Count > 0) then
     begin
        ListBox.ItemIndex:= 0;
        ListBox.Selected[0] := True;
     end;
  end;
  CopyBtn.Enabled := (ListBox.Items.Count > 0) and (ListBox.ItemIndex >= 0);
  ReadISRCCode1.Enabled := CopyBtn.Enabled;
  CopyTracks1.Enabled   := CopyBtn.Enabled;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.ResetTrackInfos;
var
   i: integer;
begin
   ListBox.Clear;
   HasCDText := False;
   editTitle.Text := '';
   for i := 0 to high(ISRCCodes) do ISRCCodes[i] := '';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.Timer1Timer(Sender: TObject);
var
   status  : TMMCDStatus;
   CurTrack: integer;
   S       : string;
begin
   with CDReader do
   begin
      status := CDReader.DeviceStatus;
      case Status of
          cdPlaying:
          begin
             ReadISRCCode1.Enabled := True;
             CopyTracks1.Enabled   := True;
             CopyBtn.Enabled  := True;
             btnPlay.Enabled  := False;
             btnPrev.Enabled  := True;
             btnNext.Enabled  := True;
             btnStop.Enabled  := True;
             btnEject.Enabled := True;
          end;
          cdStopped:
          begin
             ReadISRCCode1.Enabled := True;
             CopyTracks1.Enabled   := True;
             CopyBtn.Enabled  := True;
             btnPlay.Enabled  := True;
             btnPrev.Enabled  := False;
             btnNext.Enabled  := False;
             btnStop.Enabled  := False;
             btnEject.Enabled := True;
          end;
          else
          begin
             ReadISRCCode1.Enabled := False;
             CopyTracks1.Enabled   := False;
             CopyBtn.Enabled  := False;
             btnPlay.Enabled  := False;
             btnPrev.Enabled  := False;
             btnNext.Enabled  := False;
             btnStop.Enabled  := False;
             if (status = cdNotReady) then
                btnEject.Enabled := False
             else
                btnEject.Enabled := True;
          end;
      end;

      if DeviceReady then
      begin
         StatusBar.Panels[0].Text := 'CD Inserted';
         if CurDiskID <> DiskID then
         begin
            ResetTrackInfos;
            DisplayTOC(True);
         end;

         StatusBar.Panels[1].Text := 'Playtime: ' + MSFToTimeStr(CDReader.GetPosition,False);
         CurTrack := CDReader.GetCurrentTrack;
         S := Format('Track: %.2d',[CurTrack]);
         if HasCDText then
            S := S + ' - ' + CDReader.CDText[0].Tracks[CurTrack].TrackTitle;
         if (S <> StatusBar.Panels[2].Text) then
             StatusBar.Panels[2].Text := S;
      end
      else
      begin
         StatusBar.Panels[0].Text := 'no CD Inserted';
         if (CurDiskID <> -1) then
         begin
            CurDiskID := -1;
            ResetTrackInfos;
         end;
         StatusBar.Panels[1].Text := '';
         StatusBar.Panels[2].Text := '';
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.CopyClick(Sender: TObject);
var
   OK: Boolean;
   i: integer;
begin
   if (ListBox.ItemIndex >= 0) then
   begin
      OK := False;
      for i := 0 to ListBox.Items.Count-1 do
      if ListBox.Selected[i] and (CDReader.Tracks[i].TrackType = ttAudio) then
      begin
         OK := True;
         break;
      end;

      if OK then
      begin
         if SaveDlg.Execute then
         begin
            Timer1.Enabled := False;
            CopyDlg := TCopyDlg.Create(Self);
            try
               CopyDlg.FileName := SaveDlg.FileName;
               CopyDlg.ShowModal;
            finally
               CopyDlg.Free;
               Timer1.Enabled  := True;
            end;
         end;
      end
      else MessageDlg('No Audio Track selected !',mtInformation,[mbOK],0);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.TriggerStart(Sender: TObject);
begin
   CopyDlg.StartTimer;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.TriggerStop(Sender: TObject);
var
   NextTrack: integer;

begin
   CopyDlg.StopTimer;

   if CopyDlg.ErrorAbort then
   begin
      CopyDlg.Messages.Lines.Add('There where Errors, copy not completed.');
      CopyDlg.btnAbort.Caption := 'Close';
      CopyDlg.ErrorAbort := False;

      Trigger.Close;
   end
   else if CopyDlg.UserAbort then
   begin
      CopyDlg.Meter2.Progress := CopyDlg.Meter2.MaxValue;
      CopyDlg.Meter2.Update;
      CopyDlg.lblPercent2.Caption := '100.0 %';
      CopyDlg.lblPercent2.Update;
      CopyDlg.lblRemaining2.Caption := TimeToString(0);
      CopyDlg.lblRemaining2.Update;
      CopyDlg.Messages.Lines.Add('Copyprocess terminated by user!');

      Trigger.Close;

      MessageDlg('Copyprocess terminated by user!',mtInformation,[mbOK],0);
      CopyDlg.Close;
   end
   else
   begin
      Trigger.Close;

      NextTrack := CopyDlg.FindNextTrack;
      if (NextTrack <> CopyDlg.CurTrack) then
      begin
         CopyDlg.CopyTrack(NextTrack)
      end
      else
      begin
         CopyDlg.Messages.Lines.Add('Copy completed without any errors.');
         CopyDlg.btnAbort.Caption := 'Close';

         CopyDlg.Meter2.Progress := CopyDlg.Meter2.MaxValue;
         CopyDlg.Meter2.Update;
         CopyDlg.lblPercent2.Caption := '100.0 %';
         CopyDlg.lblPercent2.Update;
         CopyDlg.lblRemaining2.Caption := TimeToString(0);
         CopyDlg.lblRemaining2.Update;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.TriggerClose(Sender: TObject);
begin
   if CopyDlg.ErrorAbort then
   begin
      CopyDlg.Messages.Lines.Add('There where Errors, copy not completed.');
      CopyDlg.btnAbort.Caption := 'Close';
      CopyDlg.ErrorAbort := False;
   end
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.WaveFileClose(Sender: TObject);
begin
   if (trPlay in Trigger.State) then
   begin
      CopyDlg.Messages.Lines.Add('Can''t write to file, disk full ?');
      CopyDlg.ErrorAbort := True;
      Trigger.Stop;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.HeaderSized(Sender: TObject; ASection, AWidth: Integer);
begin
   ListBox.Invalidate;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.ListBoxDrawItem(Control: TWinControl; Index: Integer;
                                    R: TRect; State: TOwnerDrawState);
var
  P,Offset,i: Integer;
  C: array[0..255] of Char;
  S,S2: string;
  aBitmap: TBitmap;
  Clr: TColor;
begin
   if (CDReader.Tracks[Index].TrackType = ttAudio) then
      aBitmap := AudioBitmap
   else
      aBitmap := DataBitmap;

   Clr := ListBox.Canvas.Brush.Color;
   ListBox.Canvas.Brush.Color := ListBox.Color;
   ListBox.Canvas.BrushCopy(Classes.Rect(0,R.Top,aBitmap.Width,R.Top+aBitmap.Height),
                            aBitmap,
                            Classes.Rect(0,0,aBitmap.Width,aBitmap.Height),
                            clOlive);
   ListBox.Canvas.Brush.Color := Clr;

   Offset := aBitmap.Width;

   i := 0;

   S2 := ListBox.Items[Index];

   { find the separator in the string }
   P := Pos(#9, S2);
   while True do
   begin
      { draw the item }
      if (P = 0) then S := System.Copy(S2, 1, MaxInt)
      else S := System.Copy(S2, 1, P-1);

      R.Right := R.Left + (Header.SectionWidth[i]);
      ExtTextOut(ListBox.Canvas.Handle, R.Left, R.Top, ETO_CLIPPED or
                 ETO_OPAQUE, @R, StrPCopy(C, S), Length(S), nil);

      { move the rectangle to the next column }
      if (i = 0) then dec(R.Right,Offset);
      R.Left := R.Right;

      if (P = 0) then exit;

      S2 := System.Copy(S2, P+1, MaxInt);
      { find the next separator in the string }
      P := Pos(#9, S2);
      inc(i);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.ListBoxClick(Sender: TObject);
begin
  CopyBtn.Enabled := (ListBox.Items.Count > 0) and (ListBox.ItemIndex >= 0);
  CopyTracks1.Enabled  := CopyBtn.Enabled;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.InfoClick(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.PlayClick(Sender: TObject);
var
   i: integer;
   Start,Length: Longint;
begin
   if btnPlay.Enabled then
   begin
      Start  := -1;
      Length := -1;

      for i := 0 to ListBox.Items.Count-1 do
      begin
         if ListBox.Selected[i] and (CDReader.Tracks[i].TrackType = ttAudio) then
         begin
            if (Start = -1) then
            begin
               Start  := CDReader.Tracks[i].Start;
               Length := CDReader.Tracks[i].Length;
            end
            else inc(Length,CDReader.Tracks[i].Length);

         end
         else if (Start <> -1) then break;
      end;

      if (Start = -1) then
      begin
         MessageDlg('No Audio Track selected !',mtInformation,[mbOK],0);
         exit;
      end;

      CDReader.PlayAudio(Start,Length);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.PrevClick(Sender: TObject);
var
   cTrack: integer;
begin
   with CDReader do
   begin
      cTrack := GetCurrentTrack;
      dec(cTrack);
      if (cTrack < 1) then cTrack := Tracks.Count;
      PlayAudio(Tracks[cTrack-1].Start,Tracks[cTrack-1].Length);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.NextClick(Sender: TObject);
var
   cTrack: integer;
begin
   with CDReader do
   begin
      cTrack := GetCurrentTrack;
      inc(cTrack);
      if (cTrack > Tracks.Count) then cTrack := 1;
      PlayAudio(Tracks[cTrack-1].Start,Tracks[cTrack-1].Length);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.StopClick(Sender: TObject);
begin
   CDReader.StopAudio;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.EjectClick(Sender: TObject);
var
   status: TMMCDStatus;
begin
   status := CDReader.DeviceStatus;
   if (status = cdOpen) then
       CDReader.LoadMedia(True)
   else
       CDReader.LoadMedia(False);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.ToolBar1Click(Sender: TObject);
begin
   ToolBar.Visible := not ToolBar.Visible;
   ToolBar1.Checked := ToolBar.Visible;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.Statusbar1Click(Sender: TObject);
begin
   StatusBar.Visible := not StatusBar.Visible;
   StatusBar1.Checked := StatusBar.Visible;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.SelectAll1Click(Sender: TObject);
var
   i: integer;
begin
   for i := 0 to ListBox.Items.Count-1 do
   begin
      ListBox.Selected[i] := True;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.InvertSelection1Click(Sender: TObject);
var
   i: integer;
begin
   for i := 0 to ListBox.Items.Count-1 do
   begin
      ListBox.Selected[i] := not ListBox.Selected[i];
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.ConfigDriveClick(Sender: TObject);
begin
   with TConfigDlg.Create(Self) do
   try
      ShowModal;
   finally
      Free;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.TriggerError(Sender: TObject);
begin
   if (CopyDlg <> nil) then CopyDlg.ErrorAbort := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.miExitClick(Sender: TObject);
begin
   Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TCDMainForm.SelectWaveformat1Click(Sender: TObject);
begin
   { choose a destination format for the ACM converter }
   if ACM.ChooseFormat(ACMConverter.PWaveFormat,'') then
      ACMConverter.PWaveFormat := ACM.PWaveFormat;
end;

end.

